/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SpruceTextAlignment;
import dev.lambdaurora.spruceui.border.Border;
import dev.lambdaurora.spruceui.border.EmptyBorder;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.tooltip.Tooltip;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.tooltip.Tooltipable;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.WithBorder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;

public class SpruceLabelWidget
extends AbstractSpruceWidget
implements Tooltipable,
WithBorder {
    public static final Consumer<SpruceLabelWidget> DEFAULT_ACTION = label -> {};
    private class_2561 text;
    private List<class_5481> lines;
    private SpruceTextAlignment alignment;
    private int color = -1;
    private int maxWidth;
    private final Consumer<SpruceLabelWidget> action;
    private int baseX;
    private TooltipData tooltip = TooltipData.EMPTY;
    private Border border = EmptyBorder.EMPTY_BORDER;
    private int tooltipTicks;
    private long lastTick;

    public SpruceLabelWidget(Position position, class_2561 text, int maxWidth, Consumer<SpruceLabelWidget> action, SpruceTextAlignment alignment) {
        super(position);
        this.alignment = alignment;
        this.maxWidth = maxWidth;
        this.baseX = position.getRelativeX();
        this.action = action;
        this.setText(text);
    }

    public SpruceLabelWidget(Position position, class_2561 text, int maxWidth, Consumer<SpruceLabelWidget> action) {
        this(position, text, maxWidth, action, SpruceTextAlignment.LEFT);
    }

    public SpruceLabelWidget(Position position, class_2561 text, int maxWidth, SpruceTextAlignment alignment) {
        this(position, text, maxWidth, DEFAULT_ACTION, alignment);
    }

    public SpruceLabelWidget(Position position, class_2561 text, int maxWidth) {
        this(position, text, maxWidth, DEFAULT_ACTION);
    }

    private int getInnerX() {
        return this.getPosition().getAnchor().getX() + this.baseX;
    }

    public class_2561 getText() {
        return this.text;
    }

    public void setText(class_2561 text) {
        this.text = text;
        this.lines = this.client.field_1772.method_1728((class_5348)text, this.maxWidth);
        int width = this.lines.stream().mapToInt(arg_0 -> ((class_327)this.client.field_1772).method_30880(arg_0)).max().orElse(this.maxWidth);
        if (width > this.maxWidth) {
            width = this.maxWidth;
        }
        if (this.isCentered()) {
            this.position.setRelativeX(this.baseX + this.maxWidth / 2 - width / 2);
        } else {
            this.position.setRelativeX(this.baseX);
        }
        this.width = width;
        int n = this.lines.size();
        Objects.requireNonNull(this.client.field_1772);
        this.height = n * 9 + 2;
    }

    public boolean isCentered() {
        return this.alignment == SpruceTextAlignment.CENTER;
    }

    public SpruceTextAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(SpruceTextAlignment alignment) {
        this.alignment = alignment;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @Override
    @NotNull
    public TooltipData getTooltip() {
        return this.tooltip;
    }

    @Override
    public void setTooltip(@NotNull TooltipData tooltip) {
        Objects.requireNonNull(tooltip, "Tooltip cannot be null, the absence of a tooltip is represented by TooltipData.EMPTY.");
        this.tooltip = tooltip;
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
    }

    public void onPress() {
        this.action.accept(this);
    }

    @Override
    public boolean requiresCursor() {
        return this.action == DEFAULT_ACTION;
    }

    @Override
    protected boolean onMouseClick(@NotNull class_11909 event, boolean doubleClick) {
        if (event.method_74245() == 0 && this.hovered) {
            this.onPress();
            return true;
        }
        return false;
    }

    @Override
    protected void renderWidget(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int y = this.getY() + 2;
        for (class_5481 line : this.lines) {
            int x = switch (this.alignment) {
                default -> throw new MatchException(null, null);
                case SpruceTextAlignment.LEFT -> this.getInnerX();
                case SpruceTextAlignment.CENTER -> this.getInnerX() + this.maxWidth / 2 - this.client.field_1772.method_30880(line) / 2;
                case SpruceTextAlignment.RIGHT -> this.getInnerX() + this.maxWidth - this.client.field_1772.method_30880(line);
            };
            graphics.drawShadowedText(this.client.field_1772, line, x, y, this.color);
            y += 9;
        }
        this.getBorder().render(graphics, this, mouseX, mouseY, delta);
        if (!this.dragging) {
            Tooltip.queueFor(this, mouseX, mouseY, this.tooltipTicks, i -> {
                this.tooltipTicks = i;
            }, this.lastTick, i -> {
                this.lastTick = i;
            });
        }
    }

    @Override
    protected class_2561 getNarrationMessage() {
        return this.getText();
    }
}

